require( "scripts/style.lua" );
DebugOut("ChoosePlayer");


function trim(str)
    return string.gsub(str, "^[%s\n]*(.-)[%s\n]*$", "%1")
end


function ShowSubmitOptions( show )
	EnableWindow( "delete", show )
	EnableWindow( "chooseok", show )
	EnableWindow( "editname", show )
end

function ShowCreateOptions( show )
	EnableWindow( "newplayer", show )
end

function UpdatePlayerChoices( curUser, numUsers, userTable )

	if (numUsers >= kMaxUsers) then
		ShowCreateOptions(false)
	else
		ShowCreateOptions(true)
	end

	if (numUsers==0) then
		ShowSubmitOptions( false )
	else
		ShowSubmitOptions( true )
	end

	for i = 0,numUsers-1 do
		SetLabel( "button"..i, userTable[ i+1 ] );
		EnableWindow( "button"..i, true ) ;
	end

	for i = numUsers, kMaxUsers do
		EnableWindow( "button"..i, false ) ;
	end

	if numUsers>0 then
		SetButtonToggleState( "button"..curUser, true );
	end

	DebugOut("UpdatePlayerChoices");
	
	-- B4
	GetCurrentLevel();
end

NameFont = {
  standardFont,
  20,
  BlackColor
};

HeaderFont = {
  standardFont,
  30,
  BlackColor
};

ButtonX = kCenter - 20;
ButtonY = 120;
ButtonYSpace = 36;

kMaxUsers = 8

NameButtonGraphics = {
	"buttons/choosenameover.png",
	"buttons/choosenamedown.png",
	"buttons/choosenameover.png",
	"buttons/choosenamedown.png"
};	

NameStyle= {
	type = kRadio,
	flags = kHAlignCenter + kVAlignCenter,
	font = StandardButtonFont,
	graphics = NameButtonGraphics,
	sound = kDefaultButtonSound
};

--gSelected = -1 ;

function AddButtons( N )

	t = { SetStyle(NameStyle), BeginGroup() };

	for i = 0,N-1 do
		table.insert(t,
			Button{
				name="button"..i,
--				command=function() gSelected = i; end,
				label="#name",
				x=ButtonX,
				y=ButtonY+(ButtonYSpace*i),
				w=300,
				h=38,
				font = { standardFont, 18, BlackColor },
			}
		);	
	end

	return Group(t);
end

MakeDialog
{
	-- Name the modal dialog
	name="chooseplayer",
	Bitmap
	{ 
		image="backgrounds/largedialog",
		x=kCenter,
		y=kCenter,
		
		ChoosePlayerWindow
		{
			x = 0, y = 0, w=kMax, h=kMax,
			
			Text
			{
				font = HeaderFont,
				name = "selectaplayer",
				x=0,y=70,w=kMax,h=kMax,
				flags = kHAlignCenter + kVAlignTop,
				label = "selectaplayer"
			};
			
			AddButtons( kMaxUsers );
			
			SetStyle(MenuButtonStyle);
			Button
			{
				x=140,
				y=394+30,
				--w=200,h=50,
				name="editname",
				label="",
				type = kPush,
				label="editname",
				command =
					function()
						gEnterNameValue = GetSelectedPlayerName();
						name = DoModal("scripts/entername.lua");
						if (not(name == nil)) then
							if (not(trim(name) == "")) then
								ChangeCurrentUserName(trim(name));
								SetPlayerChoices();
								--SetWelcomeName();
							end
						end
					end
			};

			Button
			{
				x=310,
				y=434+30,
				--w=200,h=50,
				name="chooseok",
				label="ok",
				type = kPush,
				default = true,
				hflip   = true,
				command = 
					function()
						userNum = GetCurrentSelectedUser();
						SetCurrentUser(userNum);
						--SetWelcomeName();
						SendGameMessage("end_dialog");
						PopModal("chooseplayer");
					end
				
			};
				
			Button
			{
				x=310,
				y=394+30,
				--w=200,h=50,
				name="newplayer",
				label="newplayer",
				type = kPush,
				hflip   = true,
				command =
					function()
						gEnterNameValue = "";
						name = DoModal("scripts/entername.lua");
						if (not(name == nil)) then
							if (not(trim(name) == "")) then
								CreateNewUser(trim(name));
								SetPlayerChoices()
							end
						end
					end
			};
				
			Button
			{
				x=140,
				y=434+30,
				--w=200,h=50,
				name="delete",
				label="deleteplayer",
				type = kPush,
				
				command =
					function()
						result = DisplayDialog { 
							"scripts/yesno.lua", 
							body ="deleteconfirm",
							title = "deletetitle" 
						};
						if (result=='yes') then
							userNum = GetCurrentSelectedUser();
							DeleteUser(userNum)
							SetPlayerChoices()
						end
					end
				
			};
		}
	}
}


--UpdatePlayerChoices( 0,0, {} );

--SetPlayerChoices();

